'use client';

import AuthLayout from '@/components/auth-layout';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { useRouter, useSearchParams } from 'next/navigation';
import { FormEvent, useState, useEffect } from 'react';

export default function OtpPage() {
  const router = useRouter();
  const searchParams = useSearchParams();
  const [timer, setTimer] = useState(180); // 3 minutes in seconds

  useEffect(() => {
    if (timer === 0) return;
    const interval = setInterval(() => {
      setTimer((prev) => prev - 1);
    }, 1000);
    return () => clearInterval(interval);
  }, [timer]);

  const formatTime = (seconds: number) => {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;
    return `${minutes.toString().padStart(2, '0')}:${remainingSeconds.toString().padStart(2, '0')}`;
  };

  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
    const sessionId = searchParams.get('session_id');
    router.push(`/identity-verification?session_id=${sessionId}`);
  };

  return (
    <AuthLayout title="SMS megerősítés">
      <form onSubmit={handleSubmit} className="space-y-6 text-center">
        <p className="text-sm text-gray-600">
          SMS-ben küldtük el az egyszeri kódot. Kérjük, adja meg a kapott 6 jegyű kódot.
        </p>
        <div className="space-y-2">
          <Label htmlFor="otp-code" className="sr-only">Egyszeri kód</Label>
          <Input
            id="otp-code"
            placeholder="••••••"
            maxLength={6}
            className="text-center text-2xl tracking-[.5em] font-mono"
            required
          />
        </div>
        <div className="text-sm text-gray-500">
          A kód érvényes: <span className="font-bold text-[#002d5f]">{formatTime(timer)}</span>
        </div>
        <Button type="submit" className="w-full bg-[#002d5f] hover:bg-[#00254e]">
          Megerősítés
        </Button>
      </form>
    </AuthLayout>
  );
}
